# Player: huggingface_DeepSeek-V3-0324_PayoffMaximizer_A (as Player A)
# Meta-Round: 8
# Experiment: PMxPM, Run: 5
# API: huggingface, Model: deepseek-ai/DeepSeek-V3-0324
# Based on textual strategy: huggingface_DeepSeek_V3_0324_PayoffMaximizer_A_MR8_strategy.txt
# LLM Suggested Fallback: D

def huggingface_DeepSeek_V3_0324_PayoffMaximizer_A_MR8(my_history: list, opp_history: list, opponent_program_code: str) -> str:
    current_round = len(my_history) + 1
    
    # Round 1: Cooperate to establish goodwill
    if current_round == 1:
        return "C"
    
    # Rounds 2-3: Mirror opponent's previous move (tit-for-tat)
    elif current_round <= 3:
        return opp_history[-1]
    
    # Rounds 4-7: Cooperate if opponent cooperated in R2-3, else defect
    elif current_round <= 7:
        if len(opp_history) >= 2 and opp_history[1] == "C" and opp_history[2] == "C":
            return "C"
        else:
            return "D"
    
    # Rounds 8-10: Defect if opponent ever defected, else cooperate
    else:
        if "D" in opp_history:
            return "D"
        else:
            return "C"